/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWLog;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWLogQuery;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepOccurrenceHistory;
import filenet.vw.api.VWWorkObjectNumber;
import filenet.vw.api.VWWorkflowHistory;
import filenet.vw.base.logging.Logger;
import java.util.Vector;

public final class VWStepHistory
extends VWMLABase {
    private static Logger m_logger = Logger.getLogger("filenet.vw.api");
    private static final String CLASS_NAME = "VWStepHistory";
    private VWWorkflowHistory m_workflowHistory = null;
    private Vector<VWStepOccurrenceHistory> m_occurrenceHistoryList = new Vector();
    private int m_stepId = 0;
    private String m_stepName = null;
    private boolean m_bCompoundStep = false;
    VWLog m_eventLog = null;
    VWLogQuery m_logQuery = null;
    protected int m_bufferSize = 50;
    private boolean m_bInitialized = false;
    private boolean m_bInitializing = false;
    private int m_index = -1;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-08-17 02:01:28 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/3 $";
    }

    VWStepHistory(VWWorkflowHistory workflowHistory, int stepId) {
        this.m_workflowHistory = workflowHistory;
        this.m_stepId = this.m_workflowHistory.convertWorkOrderIdToStepId(stepId);
        this.setStepType(stepId);
        this.m_bInitialized = false;
    }

    public void setBufferSize(int newSize) throws VWException {
        if (newSize < 1 && this.m_bufferSize < 1) {
            throw new VWException("vw.api.SHBufferSizeInvalid", "Buffer size specified to fetch is not valid.");
        }
        this.m_bufferSize = newSize;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public boolean hasNext() {
        return this.m_index != -1 && this.m_index < this.m_occurrenceHistoryList.size();
    }

    public void resetFetch() {
        this.m_index = this.m_occurrenceHistoryList.size() > 0 ? 0 : -1;
    }

    public VWStepOccurrenceHistory next() throws VWException {
        if (this.m_index != -1 && this.m_index < this.m_occurrenceHistoryList.size()) {
            VWStepOccurrenceHistory occurrenceHistory;
            if ((occurrenceHistory = this.m_occurrenceHistoryList.elementAt(this.m_index++)) != null) {
                occurrenceHistory.initialize();
            }
            return occurrenceHistory;
        }
        return null;
    }

    VWWorkflowHistory getWorkflowHistory() {
        return this.m_workflowHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLogElement(VWLogElement logElement) {
        String methodName = "addLogElement";
        try {
            int stepId = this.m_workflowHistory.convertWorkOrderIdToStepId(logElement.getWorkOrderId());
            if (stepId != this.m_stepId) {
                return;
            }
            if (m_logger.isFinest()) {
                m_logger.finer(CLASS_NAME, "addLogElement", "stepId: " + stepId);
            }
            if (this.m_stepName == null) {
                this.m_stepName = this.m_bCompoundStep ? this.getStepNameFromMapNode(stepId) : logElement.getStepName();
            }
            if (m_logger.isFinest()) {
                m_logger.finer(CLASS_NAME, "addLogElement", "stepName: " + this.m_stepName);
            }
            int occurrenceId = 0;
            Object obj = logElement.getFieldValue("F_OccurrenceId");
            if (!(obj instanceof Integer)) {
                return;
            }
            occurrenceId = (Integer)obj;
            if (m_logger.isFinest()) {
                m_logger.finer(CLASS_NAME, "addLogElement", "occurrenceId: " + occurrenceId);
            }
            boolean bFound = false;
            VWStepOccurrenceHistory occurrence = null;
            for (int i = 0; i < this.m_occurrenceHistoryList.size(); ++i) {
                occurrence = this.m_occurrenceHistoryList.elementAt(i);
                if (occurrence.getOccurrenceId() != occurrenceId) continue;
                bFound = true;
                break;
            }
            if (!bFound) {
                occurrence = new VWStepOccurrenceHistory(this, occurrenceId);
                this.m_occurrenceHistoryList.addElement(occurrence);
            }
            if (occurrence != null) {
                occurrence.addLogElement(logElement);
            }
        }
        catch (VWException vWException) {
        }
        finally {
            if (this.m_index == -1 && this.m_occurrenceHistoryList.size() > 0) {
                this.m_index = 0;
            }
        }
    }

    void updateReceivingTime(long time) {
        this.m_workflowHistory.updateReceivingTime(time);
    }

    public int getStepId() {
        return this.m_stepId;
    }

    public String getStepName() {
        return this.translateStr(this.m_stepName);
    }

    public boolean isCompoundStep() {
        return this.m_bCompoundStep;
    }

    String getWorkflowNumber() {
        return this.m_workflowHistory.getWorkflowNumber();
    }

    String getEventLogName() {
        return this.m_workflowHistory.getEventLogName();
    }

    int getInstructionSheetId() {
        return this.m_workflowHistory.getInstructionSheetId();
    }

    protected VWSession getSession() {
        return this.m_workflowHistory.getSession();
    }

    void doRefresh() throws VWException {
        this.m_bInitialized = false;
        this.initialize();
        for (int i = 0; i < this.m_occurrenceHistoryList.size(); ++i) {
            VWStepOccurrenceHistory history = this.m_occurrenceHistoryList.elementAt(i);
            if (history == null) continue;
            history.doRefresh();
        }
    }

    void initialize() throws VWException {
        if (this.m_bInitializing || this.m_bInitialized) {
            return;
        }
        try {
            VWIndexDefinition[] indexDefs;
            this.m_bInitializing = true;
            if (this.m_eventLog == null) {
                VWSession session = this.m_workflowHistory.getSession();
                session.checkSession();
                this.m_eventLog = session.fetchEventLog(this.getEventLogName());
            }
            this.m_eventLog.setBufferSize(this.m_bufferSize);
            boolean isIndex = false;
            String indexName = null;
            VWLogDefinition logDef = this.m_eventLog.fetchLogDefinition();
            if (logDef != null && (indexDefs = logDef.getIndexes()) != null) {
                for (int i = 0; i < indexDefs.length && !isIndex; ++i) {
                    String[] fieldNames = indexDefs[i].getAuthoredFieldNames();
                    if (fieldNames[0].compareTo("F_WorkFlowNumber") != 0) continue;
                    indexName = indexDefs[i].getAuthoredName();
                    isIndex = true;
                }
            }
            String workflowNumber = this.m_workflowHistory.getWorkflowNumber();
            int instructionSheetId = this.m_workflowHistory.getInstructionSheetId();
            String sWorkOrderIdFilter = null;
            if (this.m_bCompoundStep) {
                VWInstructionDefinition[] instructionDef = this.getInstructions();
                if (instructionDef != null) {
                    boolean bStarted = false;
                    for (int i = 0; i < instructionDef.length; ++i) {
                        int id = instructionDef[i].getInstructionId();
                        if (!bStarted) {
                            sWorkOrderIdFilter = "(F_WorkOrderId = " + id;
                            bStarted = true;
                            continue;
                        }
                        sWorkOrderIdFilter = sWorkOrderIdFilter + " OR F_WorkOrderId = " + id;
                    }
                    if (bStarted) {
                        sWorkOrderIdFilter = sWorkOrderIdFilter + ")";
                    }
                }
            } else {
                sWorkOrderIdFilter = "F_WorkOrderId = " + this.m_stepId;
            }
            if (isIndex) {
                Object[] minValues = new Object[]{workflowNumber};
                Object[] maxValues = new Object[]{workflowNumber};
                Object[] subVars = new Object[]{instructionSheetId, 352};
                this.m_logQuery = instructionSheetId == -2 && this.m_stepId == 0 ? this.m_eventLog.startQuery(indexName, minValues, maxValues, 96, "(F_InstrSheetId = -2 AND  F_EventType = 140 ) ", null) : this.m_eventLog.startQuery(indexName, minValues, maxValues, 96, "(F_InstrSheetId = :a AND " + sWorkOrderIdFilter + " AND (F_EventType = :b" + " OR F_EventType = " + 405 + " OR F_EventType = " + 407 + " OR F_EventType = " + 500 + " OR F_OperationId = " + 5 + "))", subVars);
            } else {
                Object[] subVars = new Object[]{new VWWorkObjectNumber(workflowNumber), instructionSheetId};
                indexName = "F_LogTime";
                this.m_logQuery = instructionSheetId == -2 && this.m_stepId == 0 ? this.m_eventLog.startQuery(indexName, null, null, 0, "(F_InstrSheetId = -2 AND  F_EventType = 140 ) ", null) : this.m_eventLog.startQuery(indexName, null, null, 0, "F_WorkFlowNumber = :a AND F_InstrSheetId = :b AND " + sWorkOrderIdFilter + " AND (F_EventType = " + 352 + " OR F_EventType = " + 405 + " OR F_EventType = " + 407 + " OR F_EventType = " + 500 + " OR F_OperationId = " + 5 + ")", subVars);
            }
            if (this.m_logQuery != null) {
                while (this.m_logQuery.hasNext()) {
                    VWLogElement logElement = this.m_logQuery.next();
                    if (logElement == null) continue;
                    Object obj = logElement.getFieldValue("F_WPClassId");
                    int queueId = -1;
                    if (obj != null && obj instanceof Integer) {
                        queueId = (Integer)obj;
                    }
                    int operationId = -1;
                    obj = logElement.getFieldValue("F_OperationId");
                    if (obj != null && obj instanceof Integer) {
                        operationId = (Integer)obj;
                    }
                    if (operationId == -1 && queueId == -6 || operationId == 19 && queueId == -5) continue;
                    this.addLogElement(logElement);
                }
            }
        }
        catch (VWException ex) {
            throw ex;
        }
        finally {
            this.m_bInitializing = false;
        }
        this.m_bInitialized = true;
    }

    private void setStepType(int workOrderId) {
        int stepId = -1;
        try {
            VWMapDefinition mapDef = this.m_workflowHistory.getMapDefinition();
            if (mapDef != null) {
                stepId = mapDef.getContainingStepId(workOrderId);
                this.m_bCompoundStep = stepId != -1;
            }
        }
        catch (Exception ex) {
            this.m_bCompoundStep = false;
        }
    }

    protected VWInstructionDefinition[] getInstructions() throws VWException {
        VWInstructionDefinition[] instructions = null;
        VWMapDefinition mapDef = this.m_workflowHistory.getMapDefinition();
        if (mapDef != null) {
            VWMapNode mapNode = mapDef.getStep(this.m_stepId);
            if (mapNode instanceof VWCompoundStepDefinition) {
                instructions = ((VWCompoundStepDefinition)mapNode).getInstructions();
            }
        }
        return instructions;
    }

    private String getStepNameFromMapNode(int stepId) {
        String stepName = null;
        try {
            VWMapDefinition mapDef = this.m_workflowHistory.getMapDefinition();
            if (mapDef != null) {
                VWMapNode mapNode = mapDef.getStep(stepId);
                stepName = mapNode.getName();
            }
        }
        catch (Exception ex) {
            stepName = null;
        }
        return stepName;
    }
}

